import java.util.Arrays;
import java.util.Scanner;

public class MatrixOps {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        int rows = scanner.nextInt();
        int cols = scanner.nextInt();
        int subRows = scanner.nextInt();
        int subCols = scanner.nextInt();

        int[] arrayA = new int[rows * cols];
        for (int i = 0; i < rows * cols; i++) {
            arrayA[i] = scanner.nextInt();
        }

        int[][] matrix = new int[rows][cols];
        for (int i = 0; i < rows; i++) {
            for (int j = 0; j < cols; j++) {
                matrix[i][j] = arrayA[i * cols + j];
            }
        }

        int maxElement = Integer.MIN_VALUE;
        int maxRowIndex = 0;
        int maxColIndex = 0;
        for (int i = 0; i < rows; i++) {
            for (int j = 0; j < cols; j++) {
                if (matrix[i][j] > maxElement) {
                    maxElement = matrix[i][j];
                    maxRowIndex = i;
                    maxColIndex = j;
                }
            }
        }

        int temp = matrix[rows / 2][cols / 2];
        matrix[rows / 2][cols / 2] = maxElement;
        matrix[maxRowIndex][maxColIndex] = temp;

        int[][] sortedMatrix = new int[rows][cols];
        for (int i = 0; i < rows; i++) {
            Arrays.sort(matrix[i]);
            int idx = cols / 2;
            for (int j = 0; j < cols; j++) {
                sortedMatrix[i][j] = matrix[i][(j + idx) % cols];
            }
        }

        int[][][] submatrices = new int[rows - subRows + 1][cols - subCols + 1][subRows * subCols];
        for (int i = 0; i < rows - subRows + 1; i++) {
            for (int j = 0; j < cols - subCols + 1; j++) {
                for (int k = 0; k < subRows; k++) {
                    for (int l = 0; l < subCols; l++) {
                        submatrices[i][j][k * subCols + l] = sortedMatrix[i + k][j + l];
                    }
                }
            }
        }

        int totalSum = 0;
        for (int i = 0; i < rows - subRows + 1; i++) {
            for (int j = 0; j < cols - subCols + 1; j++) {
                totalSum += Arrays.stream(submatrices[i][j]).sum();
            }
        }

        System.out.println(totalSum);
    }
}